/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.bpcrcon;

import com.ibm.hwmca.base.bpcrcon.BackupCriticalConsoleDataResourceBundle;
import com.ibm.hwmca.base.bpcrcon.BackupErrorIds;
import com.ibm.hwmca.base.bpcrcon.BackupException;
import com.ibm.hwmca.base.bpcrcon.BackupExcludeUtil;
import com.ibm.hwmca.base.bpcrcon.BackupParameterKeys;
import com.ibm.hwmca.base.bpcrcon.BackupParameters;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.log.E4EventLog;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.mediasvc.InvalidFileSystemException;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceLockException;
import com.ibm.hwmca.fw.mediasvc.MediaServices;
import com.ibm.hwmca.fw.mediasvc.MediaWriteProtectedException;
import com.ibm.hwmca.fw.mediasvc.NoMediaPresentException;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.report.CompletionReportCode;
import com.ibm.hwmca.fw.task.ProgressReportListenerImpl;
import com.ibm.hwmca.fw.util.FileUtilities;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

class BackupImpl
implements BackupErrorIds,
BackupParameterKeys {
    private static final String TRACE_MASKT = "XBKPIMPT";
    private static final String TRACE_MASKF = "XBKPIMPF";
    private static final String TRACE_MASKD = "XBKPIMPD";
    private BackupParameters backupParameters = null;
    private MediaDevice backupDevice = null;
    private LocalizableText mediaName = null;
    private int returnState;

    BackupImpl() {
        Trace.trace(TRACE_MASKT, "-> BackupHandler.BackupHandler()");
        this.backupParameters = BackupParameters.getBackupParameters();
        Trace.trace(TRACE_MASKT, "<- BackupHandler.BackupHandler()");
    }

    synchronized void backupPreparation() throws BackupException {
        Trace.trace(TRACE_MASKT, "-> BackupImpl.backupPreparation()");
        try {
            this.setupTempDirectory();
            this.loadBackupMedia();
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "Exception during backup preparation" + exc);
            throw new BackupException(exc);
        }
        Trace.trace(TRACE_MASKT, "<- BackupHandler.backupPreparation()");
    }

    private void setupTempDirectory() throws IOException {
        Trace.trace(TRACE_MASKT, "-> BackupImpl.setupTempDirectory()");
        try {
            File tempDir = new File(this.backupParameters.getParm("backup.temp"));
            Trace.trace(TRACE_MASKF, "tmpdir = " + this.backupParameters.getParm("backup.temp"));
            if (!tempDir.exists()) {
                if (!tempDir.mkdir()) {
                    throw new IOException("couldn't create temp directory");
                }
                return;
            }
            FileUtilities.delete(tempDir);
            if (!tempDir.mkdir()) {
                throw new IOException("couldn't create temp directory");
            }
            String[] excludedFiles = new BackupExcludeUtil().getExcludedFilesList();
            Trace.trace(TRACE_MASKF, "Default Excluded Files List: " + this.backupParameters.getParm("backup.exclusions"));
            FileUtilities.copy(this.backupParameters.getParm("backup.exclusions"), this.backupParameters.getParm("backup.temp") + "/exfiles");
            FileWriter exclusionsFile = new FileWriter(this.backupParameters.getParm("backup.temp") + "/exfiles", true);
            if (excludedFiles != null) {
                int i = 0;
                while (i < excludedFiles.length) {
                    exclusionsFile.write(excludedFiles[i]);
                    ++i;
                }
            }
            exclusionsFile.close();
        }
        catch (IOException ioexc) {
            this.returnState = 9;
            Trace.trace(TRACE_MASKF, "Error creating temp directory: " + ioexc.getMessage());
            throw new IOException(ioexc.getMessage());
        }
        Trace.trace(TRACE_MASKT, "<- BackupImpl.setupTempDirectory()");
    }

    private void loadBackupMedia() throws BackupException {
        try {
            MediaServices ms = MediaServices.getMediaServices();
            MediaDeviceIdentifier backupMediaId = ms.getPreferredDevice(6);
            this.mediaName = ms.getMediaDisplayableName(6);
            this.backupDevice = ms.requestLock(new LocalizableText("Backup Critical Console Data"), backupMediaId);
            if (this.backupDevice.getLabel() == null) {
                throw new BackupException("null label");
            }
            if (!this.backupDevice.getLabel().equals("ACTBKP")) {
                throw new BackupException("wrong label " + this.backupDevice.getLabel());
            }
            if (!this.backupDevice.isMounted()) {
                this.backupDevice.mountReadWrite();
            }
            this.returnState = 0;
        }
        catch (IllegalArgumentException e) {
        }
        catch (MediaDeviceLockException e) {
            this.returnState = 1;
            BackupException bexc = new BackupException(e);
            throw bexc;
        }
        catch (MediaWriteProtectedException e) {
            this.returnState = 2;
            this.releaseLock();
            BackupException bexc = new BackupException(e);
            throw bexc;
        }
        catch (NoMediaPresentException e) {
            this.returnState = 3;
            this.releaseLock();
            BackupException bexc = new BackupException(e);
            throw bexc;
        }
        catch (InvalidFileSystemException e) {
            this.returnState = 7;
            this.releaseLock();
            BackupException bexc = new BackupException(e);
            throw bexc;
        }
        catch (MediaDeviceException e) {
            this.returnState = 4;
            this.releaseLock();
            BackupException bexc = new BackupException(e);
            new FrameworkLog(BackupErrorIds._logInfo, 261, bexc).log();
            throw bexc;
        }
        catch (BackupException e) {
            this.returnState = 5;
            this.releaseLock();
            BackupException bexc = new BackupException(e);
            throw bexc;
        }
        catch (Exception e) {
            this.returnState = 4;
            this.releaseLock();
            throw new BackupException(e);
        }
    }

    synchronized void doBackup() throws BackupException {
        try {
            try {
                this.setupTempDirectory();
                Trace.trace(TRACE_MASKT, "-> BackupImpl.doBackup()");
                new SystemEventLog(new FrameworkEventText(662), "BKUPSTRT").log();
                String[] cmd = new String[6];
                cmd[0] = this.backupParameters.getParm("backup.script");
                cmd[2] = this.backupParameters.getParm("backup.temp");
                cmd[3] = this.backupParameters.getParm("backup.data.dir") + "/" + this.backupParameters.getParm("backup.log");
                cmd[4] = BaseFileControl.getFilePath(this.backupParameters.getParm("backup.actbrst")) + this.backupParameters.getParm("backup.actbrst");
                cmd[5] = BaseFileControl.getFilePath(this.backupParameters.getParm("backup.build.date")) + this.backupParameters.getParm("backup.build.date");
                cmd[1] = this.backupDevice.getMountPoint().getAbsolutePath() + "/" + this.backupParameters.getParm("backup.archive");
                File archive = new File(cmd[1]);
                if (archive.exists() && !archive.delete()) {
                    throw new IOException("couldn't delete old archive");
                }
                int rc = RootProcess.executeProgram(cmd);
                Trace.trace(TRACE_MASKF, cmd[0] + " completed with rc=" + rc);
                this.backupDevice.unmount();
                new SystemEventLog(new FrameworkEventText(663), "BKUPFINN").log();
                if (rc != 0) {
                    if (rc == 1) {
                        throw new IOException("tar failed");
                    }
                    throw new IOException("unknown error");
                }
                this.returnState = 0;
                new E4EventLog(new FrameworkEventText(721), "E4BACKUPCRIT").log();
                Object var5_6 = null;
                this.releaseLock();
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, "backup(): " + exc.getMessage());
                this.returnState = 6;
                BackupException bexc = new BackupException(exc);
                new FrameworkLog(BackupErrorIds._logInfo, 261, bexc).log();
                throw bexc;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.releaseLock();
            throw throwable;
        }
        Trace.trace(TRACE_MASKT, "<- BackupImpl.doBackup()");
    }

    synchronized void backup(ProgressReportListenerImpl backupListener) throws BackupException {
        try {
            this.doBackup();
            String reportStr = null;
            if (this.returnState == 0) {
                reportStr = "Backup Successful";
                CompletionReport report = new CompletionReport(new ObjectId(this), CompletionReportCode.SUCCESS, reportStr);
                backupListener.finished(report);
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "backup(): " + exc.getMessage());
            Object[] backupErrorMsg = new String[]{new LocalizableText("com/ibm/hwmca/base/bpcrcon/res/backupres", BackupCriticalConsoleDataResourceBundle.BackupErrors(6)).toString()};
            BaseMessageText bmt = new BaseMessageText("BKP00002", backupErrorMsg);
            CompletionReport report = new CompletionReport(new ObjectId(this), CompletionReportCode.FAIL, bmt.toString());
            backupListener.finished(report);
            this.returnState = 6;
            BackupException bexc = new BackupException(exc);
            new FrameworkLog(BackupErrorIds._logInfo, 261, bexc).log();
        }
        Trace.trace(TRACE_MASKT, "<- BackupImpl.backup()");
    }

    LocalizableText getMediaName() {
        return this.mediaName;
    }

    int getState() {
        return this.returnState;
    }

    private void releaseLock() {
        try {
            this.backupDevice.unlock();
        }
        catch (MediaDeviceLockException e) {
            new FrameworkLog(BackupErrorIds._logInfo, 261, e).log();
        }
    }
}

